;;########################################################################
;; re-vis2.lsp
;; help for visualization
;;########################################################################
  

(defmeth reliability-model-object-proto :visualization-help 
  (sp alfa-if-p scree-plot p plot split-scat scat items-box item-list histogram-tot-scale )

(defmeth sp :plot-help ()
      (plot-help-window (strcat "Help for " (send self :title)))
      (paste-plot-help (format nil "Reliability Analisys's SpreadPlot is designed to visualize the analysis output and to perform new analysis as well. By means of this SpreadPlot, it is easy to compute diverse models of scale and to compare them dynamically, choosing a particular set of item s by clicking on the Item List window. Then, the SpreadPlot responds adapting itself to the selected items."))
            (show-plot-help)            (call-next-method :flush nil))

   (defmeth alfa-if-p :plot-help ()
       (plot-help-window (strcat "Help for " (send self :title)))
       (paste-plot-help (format nil "This plot shows how the Alpha coefficient is affected by each item. It is the graphical analogous for the 'Alpha if Item deleted' (see the report). The horizontal axis represents the item number and the vertical axis represents the alpha value if the item were removed from the test. The horizontal black line shows the alpha valued for all the items, it is a reference line to evaluate the 'Alpha if Item Deleted' for each item (represented as blue points).~2% Blue points represent the items, which are labeling with their names. Fynally, selecting a new subset of item in the List of Items will cause a blue horizontal line appears in the plot. This line represents the new alpha value for the selected items."))
       (show-plot-help)  (call-next-method :flush nil))

(defmeth scree-plot :plot-help ()
       (plot-help-window (strcat "Help for " (send self :title)))
(paste-plot-help (format nil "PARALLEL SCREE PLOT: ~2% The Parallel Scree plot shows the observed eigenvalues versus the mean estimated eigenvalues for each principal component. It can be used to aid in the decision about how many dimensions will be assumed to explain the inter-item correlation. This plot superposes two lines: a red line representing observed eigenvalues and a green line representing the mean estimated eigenvalues values by using the regression equation proposed by Kelle (2000). Use this plot in a exploratory - non-confirmatory - way. Select a subset of items in the list of Items to see how the dimensionality of your test depend on the items selected. If you require a more sophisticate method to decide the dimensionality of your test, we recommend using 'Horn's Parallel Analysis'.~2%"))
       (paste-plot-help (format nil "SCREE PLOT: ~2% The Scree plot shows the relative fit of each principal component. It does this by plotting the proportion of the data's variance that is fit by each component versus the component's number. The plot shows the relative importance of each component in fitting the data.~2%"))
       (paste-plot-help (format nil "The numbers beside the points provide information about the fit of each component. The first number is the proportion of the data's variance that is accounted for by the component. The second number is the difference in variance from the previous component. The third number is the total proportion of variance accounted for by the component and the preceeding components.~2%"))
       (paste-plot-help (format nil "The Scree plot can be used to aid in the decision about how many components are useful. You use it to make this decision by looking for an elbow (bend) in the curve. If there is one (and there often isn't) then the components following the bend account for relatively little additional variance, and can perhaps be ignored.~2%"))
       (show-plot-help))

(defmeth p :plot-help ()
      (plot-help-window (strcat "Help for " (send self :title)))
      (paste-plot-help 
       (format nil "
This plot represents the function that describes the relationship between eigenvalues and Theta coefficient. The horizontal line indicates the current values of Theta. Note that the maximum value for the eigenvalues is equal to the number of items. If the first eigenvalues is equal to the maximum possible, then, Theta is equal to 1. This plot is useful to illustrate this relationship, and to evaluate the changes in Theta given different subsets of items."))  (show-plot-help))

(defmeth plot :plot-help ()
      (plot-help-window (strcat "Help for " (send self :title)))
      (paste-plot-help 
       (format nil "This plot allows you to estimate how many more item would be added to obtain a specific reliability value. The horizontal black line in this plot represents the Cronbach's alpha value for all the items in the List of Items. The curve line shows how this reliability index would increase as the test length increase n times according to the Spearman-Brown's prophecy formula. This formula expresses the effect of test length upon the reliability, and it is used when estimating the reliability of a lengthened test. If a set of items are selected in the List of Items, the curve is updated.~2%"))
      (show-plot-help))

(defmeth split-scat :plot-help () (plot-help-window (strcat "Help for " (send self :title)))
      (paste-plot-help (format nil "This is a scatter plot showing the relationship betwen test halves. It is an important plot since the split halves reliability is based on test halves correlation.~2% "))
            (show-plot-help)            (call-next-method :flush nil))

 (defmeth scat :plot-help ()
      (plot-help-window (strcat "Help for " (send self :title)))
      (paste-plot-help (format nil "This is a scatterplot where horizontal axis represents the Total Scale and the vertical axis represents the first Item selected in the list. The plot allows to explore the relationship between items and total scale."))
            (show-plot-help)            (call-next-method :flush nil))

(defmeth items-box :plot-help ()
      (plot-help-window (strcat "Help for " (send self :title)))
      (paste-plot-help (format nil "This window shows the item score distributions for all the items (by default) or for selected items in the List of Item. It may be useful for exploring item score distributions. "))    (show-plot-help)            (call-next-method :flush nil))

 (defmeth item-list :plot-help ()
      (plot-help-window (strcat "Help for " (send self :title)))
      (paste-plot-help 
       (format nil "This window lists the items names (variables) in your dataset. Selecting a subset of items will produce a new visualization. Select a subset of items by using the usual mouse mode. The spreadplot will respond adapting itself to the selected items.~2%"))
      (show-plot-help)           (call-next-method :flush nil))

 (defmeth histogram-tot-scale :plot-help ()   
 (plot-help-window (strcat "Help for " (send self :title)))
      (paste-plot-help (format nil "This plot shows a histogram of the total test scores based on all the active items in your dataset. I you select a new subset of items the plot will be updated. This way, you can see how the test scores distribution changes depending on selected items.~2%"))
            (show-plot-help)  (call-next-method :flush nil))

    (defmeth split-box :plot-help () (plot-help-window (strcat "Help for " (send self :title))) (paste-plot-help (format nil "This window shows a box-diamiond-dot plot representing the observation scores in each test half.  Boxes represent the scores for even-items and uneven-items. This plot is useful to compare boths part of the test.~2%"))
            (show-plot-help)            (call-next-method :flush nil))




  )
